#ifndef _CONSOLE_CPP
#define _CONSOLE_CPP
///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

#define _WIN32_WINNT 0x0500

#include <Windows.H>
#include <Stdio.H>
#include <Stdlib.H>
#include <WinCon.h>
#include <ConIO.H>
#include <SQL.H>

#include "../Resources/Resource.H"

#include "Entry.H"
#include "Console.H"

//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

_ConIO ConIO;
bool gbConsoleOpen = false;

//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

BOOL WINAPI ConsoleHandlerRoutine(DWORD dwCtrlType)
{
    if(dwCtrlType == CTRL_CLOSE_EVENT)
    {
		return true;
    }

    return FALSE;
}

//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

bool OpenConsole(void)
{
    if(gbConsoleOpen)
        return false;

    if(AllocConsole())
    {
        gbConsoleOpen = true;

        SetConsoleCtrlHandler(ConsoleHandlerRoutine, TRUE);

        char ConTitle[255];
        sprintf(ConTitle, "%s [Version: %s]", gsTitleCaption, gsFileVersion);
        SetConsoleTitle(ConTitle);

        ConIO.StdIn  = GetStdHandle(STD_INPUT_HANDLE);
        ConIO.StdOut = GetStdHandle(STD_OUTPUT_HANDLE);
        ConIO.StdErr = GetStdHandle(STD_ERROR_HANDLE);

        return true;
    }
    return false;
}

//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

bool CloseConsole(void)
{
    if(!gbConsoleOpen)
        return false;

    if(FreeConsole())
    {
        CloseHandle(ConIO.StdIn);
        CloseHandle(ConIO.StdOut);
        CloseHandle(ConIO.StdErr);

        gbConsoleOpen = false;
        return true;
    }
    return false;
}

//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

BOOL WriteConEx(char *Buffer, int Length)
{
    DWORD NumberOfBytesWritten = 0;
    return WriteFile(ConIO.StdOut, Buffer, Length, &NumberOfBytesWritten, 0);;
}

//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

BOOL WriteCon(char *Buffer)
{
    return WriteConEx(Buffer, strlen(Buffer));
}

//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

DWORD GetConsoleInput(char *RetBuffer, int MaxLength)
{
    DWORD NumberOfBytesRead = 0;
    ReadFile(ConIO.StdIn, RetBuffer, MaxLength, &NumberOfBytesRead, 0);
    NumberOfBytesRead = (NumberOfBytesRead - 2);
    if(NumberOfBytesRead > 0)
    {
        RetBuffer[NumberOfBytesRead] = '\0';
        return NumberOfBytesRead;
    }
    return 0;
}

//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
#endif
